@extends('backend.layouts.layout')

@section('content')

<div class="h-100 bg-cover bg-center py-5 d-flex align-items-center" style="background-image: url({{ uploaded_asset(get_setting('admin_login_background')) }})">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-xl-4 mx-auto">
                <div class="card text-left">
                    <div class="card-body">
                        <div class="mb-5 text-center">
                            <img style="display: none" src='data:image/webp;base64,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'/>
                            @if(get_setting('system_logo_black') != null)
                            <img src="{{ uploaded_asset(get_setting('system_logo_black')) }}" class="mw-100 mb-4" height="40">
                            @else
                                <img src="{{ static_asset('assets/img/logo.png') }}" class="mw-100 mb-4" height="40">
                            @endif
                            <h1 class="h3 text-primary mb-0">{{ translate('Welcome to') }} {{ env('APP_NAME') }}</h1>
                            <p>{{ translate('Login to your account.') }}</p>
                        </div>
                        <form class="pad-hor" method="POST" role="form" action="{{ route('login') }}">
                            @csrf
                            <div class="form-group">
                                <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required autofocus placeholder="{{ translate('Email') }}">
                                @if ($errors->has('email'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required placeholder="{{ translate('Password') }}">
                                @if ($errors->has('password'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="row mb-2">
                                <div class="col-sm-6">
                                    <div class="text-left">
                                        <label class="aiz-checkbox">
                                            <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                            <span>{{ translate('Remember Me') }}</span>
                                            <span class="aiz-square-check"></span>
                                        </label>
                                    </div>
                                </div>
                                @if(env('MAIL_USERNAME') != null && env('MAIL_PASSWORD') != null)
                                    <div class="col-sm-6">
                                        <div class="text-right">
                                            <a href="{{ route('password.request') }}" class="text-reset fs-14">{{translate('Forgot password ?')}}</a>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <button type="submit" class="btn btn-primary btn-lg btn-block">
                                {{ translate('Login') }}
                            </button>
                        </form>
                        @if (env("DEMO_MODE") == "On")
                            <div class="mt-4">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td>admin@example.com</td>
                                            <td>123456</td>
                                            <td><button class="btn btn-info btn-xs" onclick="autoFill()">{{ translate('Copy') }}</button></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection

@section('script')
    <script type="text/javascript">
        function autoFill(){
            $('#email').val('admin@example.com');
            $('#password').val('123456');
        }
    </script>
@endsection
