<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Media\V1\PlayerStreamer;

use Twilio\ListResource;
use Twilio\Version;

class PlaybackGrantList extends ListResource {
    /**
     * Construct the PlaybackGrantList
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The unique string that identifies the PlayerStreamer
     *                    associated with this PlaybackGrant.
     */
    public function __construct(Version $version, string $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sid' => $sid, ];
    }

    /**
     * Constructs a PlaybackGrantContext
     */
    public function getContext(): PlaybackGrantContext {
        return new PlaybackGrantContext($this->version, $this->solution['sid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Media.V1.PlaybackGrantList]';
    }
}