<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Numbers\V2\RegulatoryCompliance\Bundle;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string $sid
 * @property string $bundleSid
 * @property string $accountSid
 * @property string $objectSid
 * @property \DateTime $dateCreated
 * @property string $url
 */
class ItemAssignmentInstance extends InstanceResource {
    /**
     * Initialize the ItemAssignmentInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $bundleSid The unique string that identifies the Bundle
     *                          resource.
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, array $payload, string $bundleSid, string $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'bundleSid' => Values::array_get($payload, 'bundle_sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'objectSid' => Values::array_get($payload, 'object_sid'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['bundleSid' => $bundleSid, 'sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return ItemAssignmentContext Context for this ItemAssignmentInstance
     */
    protected function proxy(): ItemAssignmentContext {
        if (!$this->context) {
            $this->context = new ItemAssignmentContext(
                $this->version,
                $this->solution['bundleSid'],
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch the ItemAssignmentInstance
     *
     * @return ItemAssignmentInstance Fetched ItemAssignmentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ItemAssignmentInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Delete the ItemAssignmentInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->proxy()->delete();
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Numbers.V2.ItemAssignmentInstance ' . \implode(' ', $context) . ']';
    }
}